% extract features from images and write them to features folder. If you
% want to change WIN_SIZES you have to repeat this change in
% rankGeneFromImages inside the Localization And Feature Extraction folder
% (Please note, this is definitely not recommended)

% number and size of the windows to use
WIN_SIZES  = {[24], [24], [12 24], [18 36],...
              [24], [24], [12 24], [18 36],...
              [24], [24], [12 24], [16 32], [18 36]};
% sampling step
steps     = [4, 4, 6, 12,...
             4, 4, 6, 12,...
             4, 4, 6, 6, 12,]*3;
% stop when you get enough data
max_n_windows = 50;
%at least these number of windows
min_n_windows =  3;

mkdir(FEATURES_FOLDER);

USE_FILE_GENES = exist('FILE_GENES', 'var');

if USE_FILE_GENES
    files_in = textread(FILE_GENES, '%s');
    files_in = files_in(1:2:end);
    files_in = char(files_in);
    EXCLUDE_GENES = zeros(size(files_in,1),1);
end
for p=1:length(PARTS)
    fprintf(1,'Extracting Textures on %s\n',char(PARTS{p}));

    if ~USE_FILE_GENES
        files_in = dir(strcat(IMAGES_FOLDER,'/',char(PARTS{p}),'/*.png'));
    end
    output_in = strcat(FEATURES_FOLDER,'/',char(PARTS{p}),'.csv');
    outfile_in = fopen(output_in,'w');
    if p==1
        outfile_names = fopen(OUT_GENES_FILE,'w');
%         outfile_labels = fopen(LABELS_FILE,'w');
    end
    sizew = WIN_SIZES{p};
    max_size = max(sizew);
    step = steps(p);
    for f=1:size(files_in,1)
        if USE_FILE_GENES
            gene_file = dir(strcat(IMAGES_FOLDER,'/',char(PARTS{p}),'/',files_in(f,:),'*.png'));
            if isempty(gene_file)
                fprintf('Gene %s did not perform successfully. It will be excluded from the feature selection.\n', files_in(f));
                EXCLUDE_GENES(f) = 1;
                continue
            else
                name_gene = strtrim(files_in(f,:));
                im = im2double(imread(strcat(IMAGES_FOLDER,'/',char(PARTS{p}),'/',gene_file(1).name)));
            end
        else
            name_gene = strtrim(files_in(f).name);
            im = im2double(imread(strcat(IMAGES_FOLDER,'/',char(PARTS{p}),'/',files_in(f).name)));
            EXCLUDE_GENES = zeros(length(files_in),1);
        end

        if p==1
            fprintf(outfile_names, '%d\t%s\n', f,name_gene);
%             fprintf(outfile_labels, '%d\n', f);
        end
        enough = false;
        myStep = step;
        while ~enough && myStep > 0
            sumFeatures = zeros(1,11*length(sizew));
            countElements = 0;
            stop = false;
            for x=max_size+1:step:size(im,1)-max_size
                if stop
                    break;
                end
                for y=max_size+1:myStep:size(im,2)-max_size
                    win = im(x:x+max_size,y:y+max_size);
                    if all(win)
                        %analyze texture
                        countElements = countElements + 1;
                        tmpFeatures = getTextureFeatures(im,x+max_size/2,y+max_size/2,sizew);
                        tmpFeatures(isnan(tmpFeatures))=0;
                        sumFeatures = sumFeatures + tmpFeatures;
                        if countElements == max_n_windows
                            stop = true;
                            break;
                        end
                    end
                end
            end
            if countElements >= min_n_windows
                enough = true;
            else
                myStep = myStep - 1;
                if myStep == 0
                    fprintf(1, '%s: not enough features (only %d) extracted in %s\n', name_gene, countElements, char(PARTS{p}));
                end
            end
        end

        sumFeatures = sumFeatures/countElements;
        fprintf(outfile_in, '%s', name_gene);
        fprintf(outfile_in, ' %f', sumFeatures);
        fprintf(outfile_in,'\n');
    end
    fclose(outfile_in);
    if p==1
        fclose(outfile_names);
%         fclose(outfile_labels);
    end
end